/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.ldap;

import com.floragunn.dlic.auth.ldap.util.Utils;
import com.floragunn.searchguard.support.WildcardMatcher;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.AuthDomainInfo;
import com.floragunn.searchguard.user.User;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.SearchResultEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;

public class LdapUser
extends User {
    private static final long serialVersionUID = 1L;
    private final transient DirEntry userEntry;
    private final String originalUsername;

    public LdapUser(String name, AuthDomainInfo authDomainInfo, String originalUsername, DirEntry userEntry, AuthCredentials credentials, int customAttrMaxValueLen, List<String> whiteListedAttributes) {
        super(name, authDomainInfo, null, credentials);
        this.originalUsername = originalUsername;
        this.userEntry = userEntry;
        Map attributes = this.getCustomAttributesMap();
        attributes.putAll(LdapUser.extractLdapAttributes(originalUsername, userEntry, customAttrMaxValueLen, whiteListedAttributes));
    }

    public DirEntry getUserEntry() {
        return this.userEntry;
    }

    public String getDn() {
        return this.userEntry.getDN();
    }

    public String getOriginalUsername() {
        return this.originalUsername;
    }

    public static Map<String, String> extractLdapAttributes(String originalUsername, DirEntry userEntry, int customAttrMaxValueLen, List<String> whiteListedAttributes) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("ldap.original.username", originalUsername);
        attributes.put("ldap.dn", userEntry.getDN());
        if (customAttrMaxValueLen > 0) {
            for (DirEntry.DirAttribute attr : userEntry.getAttributes()) {
                String val;
                if (attr == null || attr.isBinary() || attr.getName().toLowerCase().contains("password") || (val = attr.getStringValue()) == null || val.length() <= 0 || val.length() > customAttrMaxValueLen) continue;
                if (whiteListedAttributes != null && !whiteListedAttributes.isEmpty()) {
                    if (!WildcardMatcher.matchAny(whiteListedAttributes, (String)attr.getName())) continue;
                    attributes.put("attr.ldap." + attr.getName(), val);
                    continue;
                }
                attributes.put("attr.ldap." + attr.getName(), val);
            }
        }
        return Collections.unmodifiableMap(attributes);
    }

    public static final class DirEntry {
        private LdapEntry ldaptiveEntry;
        private SearchResultEntry ubEntry;

        public DirEntry(LdapEntry ldaptiveEntry) {
            this.ldaptiveEntry = Objects.requireNonNull(ldaptiveEntry);
        }

        public DirEntry(SearchResultEntry ubEntry) {
            this.ubEntry = Objects.requireNonNull(ubEntry);
        }

        public String getDN() {
            return this.ldaptiveEntry != null ? this.ldaptiveEntry.getDn() : this.ubEntry.getDN();
        }

        public LdapEntry getLdaptiveEntry() {
            return this.ldaptiveEntry;
        }

        public SearchResultEntry getUbEntry() {
            return this.ubEntry;
        }

        public Collection<DirAttribute> getAttributes() {
            if (this.ldaptiveEntry != null) {
                return this.ldaptiveEntry.getAttributes().stream().map(attr -> new DirAttribute((LdapAttribute)attr)).collect(Collectors.toList());
            }
            return this.ubEntry.getAttributes().stream().map(attr -> new DirAttribute((Attribute)attr)).collect(Collectors.toList());
        }

        public static final class DirAttribute {
            private LdapAttribute ldaptiveAttribute;
            private Attribute ubAttribute;

            public DirAttribute(Attribute ubAttribute) {
                this.ubAttribute = Objects.requireNonNull(ubAttribute);
            }

            public DirAttribute(LdapAttribute ldaptiveAttribute) {
                this.ldaptiveAttribute = Objects.requireNonNull(ldaptiveAttribute);
            }

            public boolean isBinary() {
                return this.ldaptiveAttribute != null ? this.ldaptiveAttribute.isBinary() : this.ubAttribute.needsBase64Encoding();
            }

            public String getName() {
                return this.ldaptiveAttribute != null ? this.ldaptiveAttribute.getName(false) : this.ubAttribute.getBaseName();
            }

            public int size() {
                return this.ldaptiveAttribute != null ? this.ldaptiveAttribute.size() : this.ubAttribute.size();
            }

            public String getStringValue() {
                return this.ldaptiveAttribute != null ? Utils.getSingleStringValue(this.ldaptiveAttribute) : Utils.getSingleStringValue(this.ubAttribute);
            }
        }
    }
}

